/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.UniformResourceStorage;
import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.debug.ui.internal.UniformResourceStorageEditorInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;

class UniformResourceStorageLocationProvider
implements ILocationProvider {
    private Map<IStorage, String> map = new Hashtable<IStorage, String>();

    UniformResourceStorageLocationProvider() {
    }

    public IPath getPath(Object element) {
        try {
            IStorage storage;
            if (element instanceof IStorageEditorInput && (storage = ((IStorageEditorInput)element).getStorage()) instanceof UniformResourceStorage) {
                File file;
                IPath path = ((UniformResourceStorage)storage).getFullPath();
                if (path != null) {
                    return path;
                }
                this.validateContents((UniformResourceStorage)storage, true);
                String filePath = this.map.get(storage);
                if (filePath == null && (file = this.getLocalFileForRemoteFileStorage((UniformResourceStorage)storage)) != null && file.exists()) {
                    filePath = file.toString();
                    this.map.put(storage, filePath);
                }
                if (filePath != null) {
                    return new Path(filePath);
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    void validate(UniformResourceStorageEditorInput editorInput) {
        IStorage storage = editorInput.getStorage();
        IPath path = ((UniformResourceStorage)storage).getFullPath();
        if (path != null) {
            return;
        }
        String filePath = this.map.get(storage);
        if (filePath != null && !this.validateContents((UniformResourceStorage)storage, false)) {
            try {
                this.loadRemoteFileStorage((UniformResourceStorage)storage, new File(filePath));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private File getLocalFileForRemoteFileStorage(UniformResourceStorage storage) throws CoreException {
        File file = null;
        try {
            String name = storage.getName();
            if (name.length() < 3) {
                name = "file" + name;
            }
            if (this.loadRemoteFileStorage(storage, file = File.createTempFile(name, null))) {
                file.deleteOnExit();
                return file;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
        }
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
        return null;
    }

    private boolean loadRemoteFileStorage(UniformResourceStorage storage, File file) throws CoreException {
        InputStream in = storage.getContents();
        OutputStream out = null;
        try {
            int n;
            if (!file.canWrite() && !file.delete()) {
                file.deleteOnExit();
            }
            out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            file.setReadOnly();
            return true;
        }
        catch (IOException e) {
            IdeLog.logWarning((Plugin)DebugUiPlugin.getDefault(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {
                    ignore.getCause();
                }
            }
        }
        return false;
    }

    private boolean validateContents(UniformResourceStorage storage, boolean remove) {
        boolean valid = storage.isValid();
        if (remove && !valid) {
            this.map.remove(storage);
        }
        return valid;
    }
}

